﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MicrosoftAccessDatabaseSampleProject
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            CreateAccessDatabase();
            AddUser("test name", "test surname");
            Console.WriteLine(GetSurname("test name"));
        }

        public void CreateAccessDatabase()
        {
            string connectionString = string.Format("Provider={0}; Data Source={1}; Jet OLEDB:Engine Type={2}",
                "Microsoft.Jet.OLEDB.4.0",
                "mydb.mdb",
                5);
            
            ADOX.Catalog catalog = new ADOX.Catalog();
            catalog.Create(connectionString);

            ADOX.Table table = new ADOX.TableClass();
            table.Name = "Users";   // Table name

            // Column 1 (id)
            ADOX.ColumnClass idCol = new ADOX.ColumnClass();
            idCol.Name = "Id";  // The name of the column
            idCol.ParentCatalog = catalog;
            idCol.Type = ADOX.DataTypeEnum.adInteger;   // Indicates a four byte signed integer.
            idCol.Properties["AutoIncrement"].Value = true;     // Enable the auto increment property for this column.

            // Column 2 (Name)
            ADOX.ColumnClass nameCol = new ADOX.ColumnClass();
            nameCol.Name = "Name";    // The name of the column
            nameCol.ParentCatalog = catalog;
            nameCol.Type = ADOX.DataTypeEnum.adVarWChar;   // Indicates a string value type.
            nameCol.DefinedSize = 60;   // 60 characters max.


            // Column 3 (Surname)
            ADOX.ColumnClass surnameCol = new ADOX.ColumnClass();
            surnameCol.Name = "Surname";    // The name of the column
            surnameCol.ParentCatalog = catalog;
            surnameCol.Type = ADOX.DataTypeEnum.adVarWChar;   // Indicates a string value type.
            surnameCol.DefinedSize = 60;   // 60 characters max.

            table.Columns.Append(idCol);        // Add the Id column to the table.
            table.Columns.Append(nameCol);      // Add the Name column to the table.
            table.Columns.Append(surnameCol);   // Add the Surname column to the table.

            catalog.Tables.Append(table);   // Add the table to our database.             

            // Close the connection to the database after we are done creating it and adding the table to it.
            ADODB.Connection con = (ADODB.Connection)catalog.ActiveConnection;
            if (con != null && con.State != 0)
                con.Close();
        }

        public void AddUser(string name, string surname)
        {
            string connectionString = string.Format("Provider={0}; Data Source={1}; Jet OLEDB:Engine Type={2}",
                "Microsoft.Jet.OLEDB.4.0",
                "mydb.mdb",
                5);

            using (var con = new System.Data.OleDb.OleDbConnection(connectionString))
            {
                con.Open();     // Open a connection to the database.

                string query = "INSERT INTO Users ([Name],[Surname]) VALUES (@name,@surname);";     // The query for adding a new row to our Users table.

                using (var command = new System.Data.OleDb.OleDbCommand(query, con))
                {
                    command.Parameters.AddWithValue("@name", name);
                    command.Parameters.AddWithValue("@surname", surname);
                    command.ExecuteNonQuery();
                }
            }
        }

        public string GetSurname(string name)
        {
            string connectionString = string.Format("Provider={0}; Data Source={1}; Jet OLEDB:Engine Type={2}", "Microsoft.Jet.OLEDB.4.0", "mydb.mdb", 5);

            using (var con = new System.Data.OleDb.OleDbConnection(connectionString))
            {
                con.Open();     // Open a connection to the database.

                string query = "Select Surname FROM Users WHERE name = @name;";      // The query for retriving the surname of the user with a specific name.

                using (var command = new System.Data.OleDb.OleDbCommand(query, con))
                {
                    command.Parameters.AddWithValue("@name", name);

                    return (string)command.ExecuteScalar();
                }
            }
        }
    }
}
